/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.factories;

import com.badlogic.gdx.math.RandomXS128;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidName;

@Singleton
public class HumanoidNameGenerator {
    private final List<String> maleGivenNames = new ArrayList<String>();
    private final List<String> femaleGivenNames = new ArrayList<String>();
    private static final String MALE_PATRONYM_SUFFIX = "son";
    private static final String FEMALE_PATRONYM_SUFFIX = "d\u00f3ttir";
    private static Map<String, String> genitiveReplacements = new LinkedHashMap<String, String>();

    @Inject
    public HumanoidNameGenerator() throws IOException {
        this(new File("assets/text/old_norse/given_names.csv"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HumanoidNameGenerator(File givenNamesFile) throws IOException {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(givenNamesFile);
            bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] splitLine = line.split(",");
                if (splitLine[1].equals("e")) {
                    this.maleGivenNames.add(splitLine[0]);
                    this.femaleGivenNames.add(splitLine[0]);
                } else if (splitLine[1].equals("f")) {
                    this.femaleGivenNames.add(splitLine[0]);
                } else {
                    this.maleGivenNames.add(splitLine[0]);
                }
                line = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileReader);
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly(fileReader);
        IOUtils.closeQuietly(bufferedReader);
    }

    public HumanoidName create(long seed, Gender gender) {
        RandomXS128 random = new RandomXS128(seed);
        HumanoidName name = new HumanoidName();
        List<String> givenNameList = this.maleGivenNames;
        if (gender.equals((Object)Gender.FEMALE)) {
            givenNameList = this.femaleGivenNames;
        }
        name.setFirstName(givenNameList.get(((Random)random).nextInt(givenNameList.size())));
        String lastName = this.maleGivenNames.get(((Random)random).nextInt(this.maleGivenNames.size()));
        lastName = this.convertForSurname(lastName);
        lastName = gender.equals((Object)Gender.MALE) ? lastName + MALE_PATRONYM_SUFFIX : lastName + FEMALE_PATRONYM_SUFFIX;
        name.setLastName(lastName);
        return name;
    }

    public String convertForSurname(String lastName) {
        for (Map.Entry<String, String> entry : genitiveReplacements.entrySet()) {
            if (!lastName.endsWith(entry.getKey())) continue;
            return lastName.substring(0, lastName.length() - entry.getKey().length()) + entry.getValue();
        }
        return lastName;
    }

    static {
        genitiveReplacements.put("ma\u00f0r", "manns");
        genitiveReplacements.put("\u00f6rn", "arnar");
        genitiveReplacements.put("dan", "danar");
        genitiveReplacements.put("mundr", "mundar");
        genitiveReplacements.put("\u00f0r", "\u00f0ar");
        genitiveReplacements.put("\u00f0unn", "\u00f0unar");
        genitiveReplacements.put("ir", "is");
        genitiveReplacements.put("r", "s");
        genitiveReplacements.put("ll", "ls");
        genitiveReplacements.put("nn", "ns");
        genitiveReplacements.put("a", "u");
        genitiveReplacements.put("i", "a");
    }
}

